/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractTextToNumberFilter
extends RuleFilter {
    protected static Map<String, Float> numbers = new HashMap<String, Float>();
    protected static Map<String, Float> multipliers = new HashMap<String, Float>();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        int posWord = 0;
        float total = 0.0f;
        float current = 0.0f;
        float totalDecimal = 0.0f;
        float currentDecimal = 0.0f;
        int addedZeros = 0;
        boolean percentage = false;
        boolean decimal = false;
        while (posWord < patternTokens.length && patternTokens[posWord].getEndPos() <= match.getToPos()) {
            if (patternTokens[posWord].getStartPos() >= match.getFromPos() && patternTokens[posWord].getEndPos() <= match.getToPos()) {
                String form = patternTokens[posWord].getToken().toLowerCase();
                if (posWord > 0 && this.isPercentage(patternTokens, posWord)) {
                    percentage = true;
                    break;
                }
                if (this.isComma(form)) {
                    decimal = true;
                    ++posWord;
                    continue;
                }
                if (!decimal) {
                    if (numbers.containsKey(form)) {
                        current += numbers.get(form).floatValue();
                    } else if (multipliers.containsKey(form)) {
                        if (current == 0.0f) {
                            current = 1.0f;
                        }
                        total += current * multipliers.get(form).floatValue();
                        current = 0.0f;
                    }
                } else if (numbers.containsKey(form)) {
                    int zerosToAdd = AbstractTextToNumberFilter.format(numbers.get(form).floatValue(), false).length();
                    currentDecimal = (float)((double)currentDecimal + (double)numbers.get(form).floatValue() / Math.pow(10.0, addedZeros + zerosToAdd));
                    ++addedZeros;
                }
            }
            ++posWord;
        }
        total += current;
        RuleMatch ruleMatch = match;
        String sugg = AbstractTextToNumberFilter.format(total += (totalDecimal += currentDecimal), percentage);
        ruleMatch.addSuggestedReplacement(sugg);
        return ruleMatch;
    }

    private static String format(float d, boolean percentage) {
        String result = d == (float)((long)d) ? String.format("%d", (long)d) : String.format("%s", Float.valueOf(d));
        if (percentage) {
            result = result + "\u202f%";
        }
        return result;
    }

    protected abstract boolean isComma(String var1);

    protected abstract boolean isPercentage(AnalyzedTokenReadings[] var1, int var2);
}

